FORMAT: 1A

# Requests API
Following the [Responses](05.%20Responses.md) example, this API will show you
how to define multiple requests and what data these requests can bear. Let's
demonstrate multiple requests on a trivial example of content negotiation.

## API Blueprint
+ [Previous: Responses](05.%20Responses.md)
+ [This: Raw API Blueprint](https://raw.github.com/apiaryio/api-blueprint/master/examples/06.%20Requests.md)
+ [Next: Parameters](07.%20Parameters.md)

# Group Messages
Group of all messages-related resources.

## My Message [/message]

### Retrieve a Message [GET]
In API Blueprint, _requests_ can hold exactly the same kind of information and
can be described using exactly the same structure as _responses_, only with
different signature – using the `Request` keyword. The string that follows
after the `Request` keyword is a request identifier. Again, using explanatory
and simple naming is the best way to go.

+ Request Plain Text Message

    + Headers

            Accept: text/plain

+ Response 200 (text/plain)

    + Headers

            X-My-Message-Header: 42

    + Body

            Hello World!

+ Request JSON Message

    + Headers

            Accept: application/json

+ Response 200 (application/json)

    + Headers

            X-My-Message-Header: 42

    + Body

            { "message": "Hello World!" }

### Update a Message [PUT]

+ Request Update Plain Text Message (text/plain)

        All your base are belong to us.

+ Request Update JSON Message (application/json)

        { "message": "All your base are belong to us." }

+ Response 204
